{include file='_head.tpl'}
{include file='_header.tpl'}

<!-- page content -->
<div class="container mt20">
    <div class="ele_sett_page">
		<div class="row justify-content-lg-center">
        <!-- left panel -->
        <div class="col-lg-12">
            <div class="ele_content p-2 ele_scroll ele_sett_side ele_mobi_sett_side {if $view == "" && $show_categories}active{/if}">
				<h2 class="ele_page_title small mt-2 mb-3 mx-3">{__("Settings")}</h2>
				<ul class="side-nav">
					<li {if $view == "" && !$show_categories}class="active"{/if}>
						<a href="{$system['system_url']}/settings">
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81V16.18C2 19.83 4.17 22 7.81 22H16.18C19.82 22 21.99 19.83 21.99 16.19V7.81C22 4.17 19.83 2 16.19 2ZM7.67 5.5C7.67 5.09 8.01 4.75 8.42 4.75C8.83 4.75 9.17 5.09 9.17 5.5V9.4C9.17 9.81 8.83 10.15 8.42 10.15C8.01 10.15 7.67 9.81 7.67 9.4V5.5ZM9.52282 16.4313C9.31938 16.5216 9.17 16.7132 9.17 16.9358V18.5C9.17 18.91 8.83 19.25 8.42 19.25C8.01 19.25 7.67 18.91 7.67 18.5V16.9358C7.67 16.7132 7.5206 16.5216 7.31723 16.4311C6.36275 16.0064 5.7 15.058 5.7 13.95C5.7 12.45 6.92 11.22 8.42 11.22C9.92 11.22 11.15 12.44 11.15 13.95C11.15 15.0582 10.4791 16.0066 9.52282 16.4313ZM16.33 18.5C16.33 18.91 15.99 19.25 15.58 19.25C15.17 19.25 14.83 18.91 14.83 18.5V14.6C14.83 14.19 15.17 13.85 15.58 13.85C15.99 13.85 16.33 14.19 16.33 14.6V18.5ZM15.58 12.77C14.08 12.77 12.85 11.55 12.85 10.04C12.85 8.93185 13.5209 7.98342 14.4772 7.55873C14.6806 7.46839 14.83 7.27681 14.83 7.05421V5.5C14.83 5.09 15.17 4.75 15.58 4.75C15.99 4.75 16.33 5.09 16.33 5.5V7.06421C16.33 7.28681 16.4794 7.47835 16.6828 7.56885C17.6372 7.9936 18.3 8.94195 18.3 10.05C18.3 11.55 17.08 12.77 15.58 12.77Z" fill="currentColor"></path></svg> {__("Account Settings")}
						</a>
					</li>

					<li {if $view == "profile"}class="active"{/if}>
						<a href="#info-settings" data-toggle="collapse" {if $view == "profile"}aria-expanded="true"{/if}>
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M22 12C22 6.49 17.51 2 12 2C6.49 2 2 6.49 2 12C2 14.9 3.25 17.51 5.23 19.34C5.23 19.35 5.23 19.35 5.22 19.36C5.32 19.46 5.44 19.54 5.54 19.63C5.6 19.68 5.65 19.73 5.71 19.77C5.89 19.92 6.09 20.06 6.28 20.2C6.35 20.25 6.41 20.29 6.48 20.34C6.67 20.47 6.87 20.59 7.08 20.7C7.15 20.74 7.23 20.79 7.3 20.83C7.5 20.94 7.71 21.04 7.93 21.13C8.01 21.17 8.09 21.21 8.17 21.24C8.39 21.33 8.61 21.41 8.83 21.48C8.91 21.51 8.99 21.54 9.07 21.56C9.31 21.63 9.55 21.69 9.79 21.75C9.86 21.77 9.93 21.79 10.01 21.8C10.29 21.86 10.57 21.9 10.86 21.93C10.9 21.93 10.94 21.94 10.98 21.95C11.32 21.98 11.66 22 12 22C12.34 22 12.68 21.98 13.01 21.95C13.05 21.95 13.09 21.94 13.13 21.93C13.42 21.9 13.7 21.86 13.98 21.8C14.05 21.79 14.12 21.76 14.2 21.75C14.44 21.69 14.69 21.64 14.92 21.56C15 21.53 15.08 21.5 15.16 21.48C15.38 21.4 15.61 21.33 15.82 21.24C15.9 21.21 15.98 21.17 16.06 21.13C16.27 21.04 16.48 20.94 16.69 20.83C16.77 20.79 16.84 20.74 16.91 20.7C17.11 20.58 17.31 20.47 17.51 20.34C17.58 20.3 17.64 20.25 17.71 20.2C17.91 20.06 18.1 19.92 18.28 19.77C18.34 19.72 18.39 19.67 18.45 19.63C18.56 19.54 18.67 19.45 18.77 19.36C18.77 19.35 18.77 19.35 18.76 19.34C20.75 17.51 22 14.9 22 12ZM16.94 16.97C14.23 15.15 9.79 15.15 7.06 16.97C6.62 17.26 6.26 17.6 5.96 17.97C4.44 16.43 3.5 14.32 3.5 12C3.5 7.31 7.31 3.5 12 3.5C16.69 3.5 20.5 7.31 20.5 12C20.5 14.32 19.56 16.43 18.04 17.97C17.75 17.6 17.38 17.26 16.94 16.97Z" fill="#2b53a4"/><path d="M12 6.92969C9.93 6.92969 8.25 8.60969 8.25 10.6797C8.25 12.7097 9.84 14.3597 11.95 14.4197C11.98 14.4197 12.02 14.4197 12.04 14.4197C12.06 14.4197 12.09 14.4197 12.11 14.4197C12.12 14.4197 12.13 14.4197 12.13 14.4197C14.15 14.3497 15.74 12.7097 15.75 10.6797C15.75 8.60969 14.07 6.92969 12 6.92969Z" fill="#2b53a4"/></svg> {__("Edit Profile")}
						</a>
						<div class='collapse {if $view == "profile"}show{/if}' id="info-settings">
							<ul>
								<li {if $view == "profile" && $sub_view == ""}class="active"{/if}>
									<a href="{$system['system_url']}/settings/profile">
										{__("Basic")}
									</a>
								</li>
								{if $system['work_info_enabled']}
									<li {if $view == "profile" && $sub_view == "work"}class="active"{/if}>
										<a href="{$system['system_url']}/settings/profile/work">
											{__("Work")}
										</a>
									</li>
								{/if}
								{if $system['location_info_enabled']}
									<li {if $view == "profile" && $sub_view == "location"}class="active"{/if}>
										<a href="{$system['system_url']}/settings/profile/location">
											{__("Location")}
										</a>
									</li>
								{/if}
								{if $system['education_info_enabled']}
									<li {if $view == "profile" && $sub_view == "education"}class="active"{/if}>
										<a href="{$system['system_url']}/settings/profile/education">
											{__("Education")}
										</a>
									</li>
								{/if}
								{if $custom_fields['other']}
									<li {if $view == "profile" && $sub_view == "other"}class="active"{/if}>
										<a href="{$system['system_url']}/settings/profile/other">
											{__("Other")}
										</a>
									</li>
								{/if}
								{if $system['social_info_enabled']}
									<li {if $view == "profile" && $sub_view == "social"}class="active"{/if}>
										<a href="{$system['system_url']}/settings/profile/social">
											{__("Social Links")}
										</a>
									</li>
								{/if}
								{if $system['system_profile_background_enabled']}
									<li {if $view == "profile" && $sub_view == "design"}class="active"{/if}>
										<a href="{$system['system_url']}/settings/profile/design">
											{__("Design")}
										</a>
									</li>
								{/if}
							</ul>
						</div>
					</li>

					<li {if $view == "security"}class="active"{/if}>
						<a href="#security-settings" data-toggle="collapse" {if $view == "security"}aria-expanded="true"{/if}>
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18.5408 4.17063L13.0408 2.11062C12.4708 1.90063 11.5408 1.90063 10.9708 2.11062L5.47078 4.17063C4.41078 4.57063 3.55078 5.81063 3.55078 6.94063V15.0406C3.55078 15.8506 4.08078 16.9206 4.73078 17.4006L10.2308 21.5106C11.2008 22.2406 12.7908 22.2406 13.7608 21.5106L19.2608 17.4006C19.9108 16.9106 20.4408 15.8506 20.4408 15.0406V6.94063C20.4508 5.81063 19.5908 4.57063 18.5408 4.17063ZM12.7508 12.8706V15.5006C12.7508 15.9106 12.4108 16.2506 12.0008 16.2506C11.5908 16.2506 11.2508 15.9106 11.2508 15.5006V12.8706C10.2408 12.5506 9.50078 11.6106 9.50078 10.5006C9.50078 9.12062 10.6208 8.00063 12.0008 8.00063C13.3808 8.00063 14.5008 9.12062 14.5008 10.5006C14.5008 11.6206 13.7608 12.5506 12.7508 12.8706Z" fill="#8bc34a"/></svg> {__("Security Settings")}
						</a>
						<div class='collapse {if $view == "security"}show{/if}' id="security-settings">
							<ul>
								<li {if $view == "security" && $sub_view == "password"}class="active"{/if}>
									<a href="{$system['system_url']}/settings/security/password">
										{__("Password")}
									</a>
								</li>
								<li {if $view == "security" && $sub_view == "sessions"}class="active"{/if}>
									<a href="{$system['system_url']}/settings/security/sessions">
										{__("Manage Sessions")}
									</a>
								</li>
								{if $system['two_factor_enabled']}
									<li {if $view == "security" && $sub_view == "two-factor"}class="active"{/if}>
										<a href="{$system['system_url']}/settings/security/two-factor">
											{__("Two-Factor Authentication")}
										</a>
									</li>
								{/if}
							</ul>
						</div>
					</li>

					<li {if $view == "privacy"}class="active"{/if}>
						<a href="{$system['system_url']}/settings/privacy">
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18.5002 4.11031L13.5102 2.24031C12.6802 1.93031 11.3202 1.93031 10.4902 2.24031L5.50016 4.11031C4.35016 4.54031 3.41016 5.90031 3.41016 7.12031V14.5503C3.41016 15.7303 4.19016 17.2803 5.14016 17.9903L9.44016 21.2003C10.8502 22.2603 13.1702 22.2603 14.5802 21.2003L18.8802 17.9903C19.8302 17.2803 20.6102 15.7303 20.6102 14.5503V7.12031C20.5902 5.90031 19.6502 4.54031 18.5002 4.11031ZM11.9302 7.03031C13.1102 7.03031 14.0702 7.99031 14.0702 9.17031C14.0702 10.3303 13.1602 11.2603 12.0102 11.3003H11.9902H11.9702C11.9502 11.3003 11.9302 11.3003 11.9102 11.3003C10.7102 11.2603 9.81016 10.3303 9.81016 9.17031C9.80016 7.99031 10.7602 7.03031 11.9302 7.03031ZM14.1902 16.3603C13.5802 16.7603 12.7902 16.9703 12.0002 16.9703C11.2102 16.9703 10.4102 16.7703 9.81016 16.3603C9.24016 15.9803 8.93016 15.4603 8.92016 14.8903C8.92016 14.3303 9.24016 13.7903 9.81016 13.4103C11.0202 12.6103 12.9902 12.6103 14.2002 13.4103C14.7702 13.7903 15.0902 14.3103 15.0902 14.8803C15.0802 15.4403 14.7602 15.9803 14.1902 16.3603Z" fill="#ffb307"/></svg> {__("Privacy")}
						</a>
					</li>

					<li {if $view == "notifications"}class="active"{/if}>
						<a href="{$system['system_url']}/settings/notifications">
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19.3399 14.49L18.3399 12.83C18.1299 12.46 17.9399 11.76 17.9399 11.35V8.82C17.9399 6.47 16.5599 4.44 14.5699 3.49C14.0499 2.57 13.0899 2 11.9899 2C10.8999 2 9.91994 2.59 9.39994 3.52C7.44994 4.49 6.09994 6.5 6.09994 8.82V11.35C6.09994 11.76 5.90994 12.46 5.69994 12.82L4.68994 14.49C4.28994 15.16 4.19994 15.9 4.44994 16.58C4.68994 17.25 5.25994 17.77 5.99994 18.02C7.93994 18.68 9.97994 19 12.0199 19C14.0599 19 16.0999 18.68 18.0399 18.03C18.7399 17.8 19.2799 17.27 19.5399 16.58C19.7999 15.89 19.7299 15.13 19.3399 14.49Z" fill="#673ab7"/><path d="M14.8297 20.01C14.4097 21.17 13.2997 22 11.9997 22C11.2097 22 10.4297 21.68 9.87969 21.11C9.55969 20.81 9.31969 20.41 9.17969 20C9.30969 20.02 9.43969 20.03 9.57969 20.05C9.80969 20.08 10.0497 20.11 10.2897 20.13C10.8597 20.18 11.4397 20.21 12.0197 20.21C12.5897 20.21 13.1597 20.18 13.7197 20.13C13.9297 20.11 14.1397 20.1 14.3397 20.07C14.4997 20.05 14.6597 20.03 14.8297 20.01Z" fill="#673ab7"/></svg> {__("Notifications")}
						</a>
					</li>

					{if $system['social_login_enabled']}
						{if $system['facebook_login_enabled'] || $system['google_login_enabled'] || $system['twitter_login_enabled'] || $system['linkedin_login_enabled'] || $system['vkontakte_login_enabled'] || $system['wordpress_login_enabled'] || $system['sngine_login_enabled']}
							<li {if $view == "linked"}class="active"{/if}>
								<a href="{$system['system_url']}/settings/linked">
									<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.3591 12.7315C19.9891 12.7315 19.6791 12.4515 19.6391 12.0815C19.3991 9.88154 18.2191 7.90154 16.3991 6.64154C16.0691 6.41154 15.9891 5.96154 16.2191 5.63154C16.4491 5.30154 16.8991 5.22154 17.2291 5.45154C19.3991 6.96154 20.7991 9.32154 21.0891 11.9315C21.1291 12.3315 20.8391 12.6915 20.4391 12.7315C20.4091 12.7315 20.3891 12.7315 20.3591 12.7315Z" fill="#009da0"/><path d="M3.73931 12.7812C3.71931 12.7812 3.68931 12.7812 3.66931 12.7812C3.26931 12.7412 2.97931 12.3812 3.01931 11.9812C3.28931 9.37118 4.66931 7.01118 6.81931 5.49118C7.13931 5.26118 7.59931 5.34118 7.82931 5.66118C8.05931 5.99118 7.97931 6.44118 7.65931 6.67118C5.85931 7.95118 4.68931 9.93118 4.46931 12.1212C4.42931 12.5012 4.10931 12.7812 3.73931 12.7812Z" fill="#009da0"/><path d="M15.9906 21.1003C14.7606 21.6903 13.4406 21.9903 12.0606 21.9903C10.6206 21.9903 9.25059 21.6703 7.97059 21.0203C7.61059 20.8503 7.47059 20.4103 7.65059 20.0503C7.82059 19.6903 8.26059 19.5503 8.62059 19.7203C9.25059 20.0403 9.92059 20.2603 10.6006 20.3903C11.5206 20.5703 12.4606 20.5803 13.3806 20.4203C14.0606 20.3003 14.7306 20.0903 15.3506 19.7903C15.7206 19.6203 16.1606 19.7603 16.3206 20.1303C16.5006 20.4903 16.3606 20.9303 15.9906 21.1003Z" fill="#009da0"/><path d="M12.0505 2.01172C10.5005 2.01172 9.23047 3.27172 9.23047 4.83172C9.23047 6.39172 10.4905 7.65172 12.0505 7.65172C13.6105 7.65172 14.8705 6.39172 14.8705 4.83172C14.8705 3.27172 13.6105 2.01172 12.0505 2.01172Z" fill="#009da0"/><path d="M5.05047 13.8711C3.50047 13.8711 2.23047 15.1311 2.23047 16.6911C2.23047 18.2511 3.49047 19.5111 5.05047 19.5111C6.61047 19.5111 7.87047 18.2511 7.87047 16.6911C7.87047 15.1311 6.60047 13.8711 5.05047 13.8711Z" fill="#009da0"/><path d="M18.9509 13.8711C17.4009 13.8711 16.1309 15.1311 16.1309 16.6911C16.1309 18.2511 17.3909 19.5111 18.9509 19.5111C20.5109 19.5111 21.7709 18.2511 21.7709 16.6911C21.7709 15.1311 20.5109 13.8711 18.9509 13.8711Z" fill="#009da0"/></svg> {__("Linked Accounts")}
								</a>
							</li>
						{/if}
					{/if}
					
					<li {if $view == "addresses"}class="active"{/if}>
						<a href="{$system['system_url']}/settings/addresses">
							<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="#00bcd4" d="M480-216q-10 0-19.5-3t-17.5-9q-81-63-162-158.5T200-594q0-71 25.5-124.5T291-808q40-36 90-54t99-18q49 0 99 18t90 54q40 36 65.5 89.5T760-594q0 112-81 207.5T517-228q-8 6-17.5 9t-19.5 3Zm0-304q33 0 56.5-23.5T560-600q0-33-23.5-56.5T480-680q-33 0-56.5 23.5T400-600q0 33 23.5 56.5T480-520ZM240-80q-17 0-28.5-11.5T200-120q0-17 11.5-28.5T240-160h480q17 0 28.5 11.5T760-120q0 17-11.5 28.5T720-80H240Z"/></svg> {__("Your Addresses")}
						</a>
					</li>

					{if $system['packages_enabled']}
						<li {if $view == "membership"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/membership">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18 3H6C3.79 3 2 4.78 2 6.97V17.03C2 19.22 3.79 21 6 21H18C20.21 21 22 19.22 22 17.03V6.97C22 4.78 20.21 3 18 3ZM8.5 7.17C9.77 7.17 10.81 8.21 10.81 9.48C10.81 10.75 9.77 11.79 8.5 11.79C7.23 11.79 6.19 10.75 6.19 9.48C6.19 8.21 7.23 7.17 8.5 7.17ZM12.37 16.66C12.28 16.76 12.14 16.82 12 16.82H5C4.86 16.82 4.72 16.76 4.63 16.66C4.54 16.56 4.49 16.42 4.5 16.28C4.67 14.6 6.01 13.27 7.69 13.11C8.22 13.06 8.77 13.06 9.3 13.11C10.98 13.27 12.33 14.6 12.49 16.28C12.51 16.42 12.46 16.56 12.37 16.66ZM19 16.75H17C16.59 16.75 16.25 16.41 16.25 16C16.25 15.59 16.59 15.25 17 15.25H19C19.41 15.25 19.75 15.59 19.75 16C19.75 16.41 19.41 16.75 19 16.75ZM19 12.75H15C14.59 12.75 14.25 12.41 14.25 12C14.25 11.59 14.59 11.25 15 11.25H19C19.41 11.25 19.75 11.59 19.75 12C19.75 12.41 19.41 12.75 19 12.75ZM19 8.75H14C13.59 8.75 13.25 8.41 13.25 8C13.25 7.59 13.59 7.25 14 7.25H19C19.41 7.25 19.75 7.59 19.75 8C19.75 8.41 19.41 8.75 19 8.75Z" fill="#009688"/></svg> {__("Membership")}
							</a>
						</li>
					{/if}

					{if $user->_data['can_invite_users']}
						<li {if $view == "invitations"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/invitations">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81V16.18C2 19.83 4.17 22 7.81 22H16.18C19.82 22 21.99 19.83 21.99 16.19V7.81C22 4.17 19.83 2 16.19 2ZM8.18 16.77C8.16 16.77 8.13 16.77 8.11 16.77C7.14 16.68 6.23 16.23 5.55 15.51C3.95 13.83 3.95 11.1 5.55 9.42L7.74 7.12C8.52 6.3 9.57 5.84 10.69 5.84C11.81 5.84 12.86 6.29 13.64 7.12C15.24 8.8 15.24 11.53 13.64 13.21L12.55 14.36C12.26 14.66 11.79 14.67 11.49 14.39C11.19 14.1 11.18 13.63 11.46 13.33L12.55 12.18C13.61 11.07 13.61 9.26 12.55 8.16C11.56 7.12 9.82 7.12 8.82 8.16L6.63 10.46C5.57 11.57 5.57 13.38 6.63 14.48C7.06 14.94 7.64 15.22 8.25 15.28C8.66 15.32 8.96 15.69 8.92 16.1C8.89 16.48 8.56 16.77 8.18 16.77ZM18.45 14.59L16.26 16.89C15.48 17.71 14.43 18.17 13.31 18.17C12.19 18.17 11.14 17.72 10.36 16.89C8.76 15.21 8.76 12.48 10.36 10.8L11.45 9.65C11.74 9.35 12.21 9.34 12.51 9.62C12.81 9.91 12.82 10.38 12.54 10.68L11.45 11.83C10.39 12.94 10.39 14.75 11.45 15.85C12.44 16.89 14.18 16.9 15.18 15.85L17.37 13.55C18.43 12.44 18.43 10.63 17.37 9.53C16.94 9.07 16.36 8.79 15.75 8.73C15.34 8.69 15.04 8.32 15.08 7.91C15.12 7.5 15.48 7.19 15.9 7.24C16.87 7.34 17.78 7.78 18.46 8.5C20.05 10.17 20.05 12.91 18.45 14.59Z" fill="#2196f3"/></svg> {__("Invitations")}
							</a>
						</li>
					{/if}
					
					{if $user->_data['can_sell_products'] && $system['market_shopping_cart_enabled']}
						<li {if $view == "market"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/market">
								<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="#9c27b0" d="M201-120q-33 0-56.5-23.5T121-200v-318q-23-21-35.5-54t-.5-72l42-136q8-26 28.5-43t47.5-17h556q27 0 47 16.5t29 43.5l42 136q12 39-.5 71T841-518v318q0 33-23.5 56.5T761-120H201Zm368-440q27 0 41-18.5t11-41.5l-22-140h-78v148q0 21 14 36.5t34 15.5Zm-180 0q23 0 37.5-15.5T441-612v-148h-78l-22 140q-4 24 10.5 42t37.5 18Zm-178 0q18 0 31.5-13t16.5-33l22-154h-78l-40 134q-6 20 6.5 43t41.5 23Zm540 0q29 0 42-23t6-43l-42-134h-76l22 154q3 20 16.5 33t31.5 13Z"></path></svg> {__("Marketplace")}
							</a>
						</li>
					{/if}
			
					{if $system['affiliates_enabled']}
						<li {if $view == "affiliates"}class="active"{/if}>
							<a href="#affiliates-settings" data-toggle="collapse" {if $view == "affiliates"}aria-expanded="true"{/if}>
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 2C9.38 2 7.25 4.13 7.25 6.75C7.25 9.32 9.26 11.4 11.88 11.49C11.96 11.48 12.04 11.48 12.1 11.49C12.12 11.49 12.13 11.49 12.15 11.49C12.16 11.49 12.16 11.49 12.17 11.49C14.73 11.4 16.74 9.32 16.75 6.75C16.75 4.13 14.62 2 12 2Z" fill="#e91e63"/><path d="M17.0809 14.1489C14.2909 12.2889 9.74094 12.2889 6.93094 14.1489C5.66094 14.9989 4.96094 16.1489 4.96094 17.3789C4.96094 18.6089 5.66094 19.7489 6.92094 20.5889C8.32094 21.5289 10.1609 21.9989 12.0009 21.9989C13.8409 21.9989 15.6809 21.5289 17.0809 20.5889C18.3409 19.7389 19.0409 18.5989 19.0409 17.3589C19.0309 16.1289 18.3409 14.9889 17.0809 14.1489ZM14.0009 18.1289H12.7509V19.3789C12.7509 19.7889 12.4109 20.1289 12.0009 20.1289C11.5909 20.1289 11.2509 19.7889 11.2509 19.3789V18.1289H10.0009C9.59094 18.1289 9.25094 17.7889 9.25094 17.3789C9.25094 16.9689 9.59094 16.6289 10.0009 16.6289H11.2509V15.3789C11.2509 14.9689 11.5909 14.6289 12.0009 14.6289C12.4109 14.6289 12.7509 14.9689 12.7509 15.3789V16.6289H14.0009C14.4109 16.6289 14.7509 16.9689 14.7509 17.3789C14.7509 17.7889 14.4109 18.1289 14.0009 18.1289Z" fill="#e91e63"/></svg> {__("Affiliates")}
							</a>
							<div class='collapse {if $view == "affiliates"}show{/if}' id="affiliates-settings">
								<ul>
									<li {if $view == "affiliates" && $sub_view == ""}class="active"{/if}>
										<a href="{$system['system_url']}/settings/affiliates">
											{__("My Affiliates")}
										</a>
									</li>
									{if $system['affiliates_money_withdraw_enabled']}
										<li {if $view == "affiliates" && $sub_view == "payments"}class="active"{/if}>
											<a href="{$system['system_url']}/settings/affiliates/payments">
												{__("Payments")}
											</a>
										</li>
									{/if}
								</ul>
							</div>
						</li>
					{/if}

					{if $system['points_enabled']}
						<li {if $view == "points"}class="active"{/if}>
							<a href="#points-settings" data-toggle="collapse" {if $view == "points"}aria-expanded="true"{/if}>
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21.9199 16.7486C21.5899 19.4086 19.4099 21.5886 16.7499 21.9186C15.1399 22.1186 13.6399 21.6786 12.4699 20.8186C11.7999 20.3286 11.9599 19.2886 12.7599 19.0486C15.7699 18.1386 18.1399 15.7586 19.0599 12.7486C19.2999 11.9586 20.3399 11.7986 20.8299 12.4586C21.6799 13.6386 22.1199 15.1386 21.9199 16.7486Z" fill="#3f51b5"/><path d="M9.99 2C5.58 2 2 5.58 2 9.99C2 14.4 5.58 17.98 9.99 17.98C14.4 17.98 17.98 14.4 17.98 9.99C17.97 5.58 14.4 2 9.99 2ZM9.05 8.87L11.46 9.71C12.33 10.02 12.75 10.63 12.75 11.57C12.75 12.65 11.89 13.54 10.84 13.54H10.75V13.59C10.75 14 10.41 14.34 10 14.34C9.59 14.34 9.25 14 9.25 13.59V13.53C8.14 13.48 7.25 12.55 7.25 11.39C7.25 10.98 7.59 10.64 8 10.64C8.41 10.64 8.75 10.98 8.75 11.39C8.75 11.75 9.01 12.04 9.33 12.04H10.83C11.06 12.04 11.24 11.83 11.24 11.57C11.24 11.22 11.18 11.2 10.95 11.12L8.54 10.28C7.68 9.98 7.25 9.37 7.25 8.42C7.25 7.34 8.11 6.45 9.16 6.45H9.25V6.41C9.25 6 9.59 5.66 10 5.66C10.41 5.66 10.75 6 10.75 6.41V6.47C11.86 6.52 12.75 7.45 12.75 8.61C12.75 9.02 12.41 9.36 12 9.36C11.59 9.36 11.25 9.02 11.25 8.61C11.25 8.25 10.99 7.96 10.67 7.96H9.17C8.94 7.96 8.76 8.17 8.76 8.43C8.75 8.77 8.81 8.79 9.05 8.87Z" fill="#3f51b5"/></svg> {__("Points")}
							</a>
							<div class='collapse {if $view == "points"}show{/if}' id="points-settings">
								<ul>
									<li {if $view == "points" && $sub_view == ""}class="active"{/if}>
										<a href="{$system['system_url']}/settings/points">
											{__("My Points")}
										</a>
									</li>
									{if $system['points_per_currency'] > 0 && $system['points_money_withdraw_enabled']}
										<li {if $view == "points" && $sub_view == "payments"}class="active"{/if}>
											<a href="{$system['system_url']}/settings/points/payments">
												{__("Payments")}
											</a>
										</li>
									{/if}
								</ul>
							</div>
						</li>
					{/if}

					{if $user->_data['can_raise_funding']}
						<li {if $view == "funding"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/funding">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M17 4H7C4 4 2 5.5 2 9V12.56C2 12.93 2.38 13.16 2.71 13.01C3.69 12.56 4.82 12.39 6.01 12.6C8.64 13.07 10.57 15.51 10.5 18.18C10.49 18.6 10.43 19.01 10.32 19.41C10.24 19.72 10.49 20.01 10.81 20.01H17C20 20.01 22 18.51 22 15.01V9C22 5.5 20 4 17 4ZM12 14.5C10.62 14.5 9.5 13.38 9.5 12C9.5 10.62 10.62 9.5 12 9.5C13.38 9.5 14.5 10.62 14.5 12C14.5 13.38 13.38 14.5 12 14.5ZM19.25 14C19.25 14.41 18.91 14.75 18.5 14.75C18.09 14.75 17.75 14.41 17.75 14V10C17.75 9.59 18.09 9.25 18.5 9.25C18.91 9.25 19.25 9.59 19.25 10V14Z" fill="#4caf50"/><path d="M5 14C2.79 14 1 15.79 1 18C1 18.75 1.21 19.46 1.58 20.06C2.27 21.22 3.54 22 5 22C6.46 22 7.73 21.22 8.42 20.06C8.79 19.46 9 18.75 9 18C9 15.79 7.21 14 5 14ZM6.49 18.73H5.75V19.51C5.75 19.92 5.41 20.26 5 20.26C4.59 20.26 4.25 19.92 4.25 19.51V18.73H3.51C3.1 18.73 2.76 18.39 2.76 17.98C2.76 17.57 3.1 17.23 3.51 17.23H4.25V16.52C4.25 16.11 4.59 15.77 5 15.77C5.41 15.77 5.75 16.11 5.75 16.52V17.23H6.49C6.9 17.23 7.24 17.57 7.24 17.98C7.24 18.39 6.91 18.73 6.49 18.73Z" fill="#4caf50"/></svg> {__("Funding")}
							</a>
						</li>
					{/if}
					
					{if $user->_data['can_monetize_content']}
						<li {if $view == "monetization"}class="active" {/if}>
							<a href="#monetization-settings" data-toggle="collapse" {if $view == "monetization"}aria-expanded="true" {/if}>
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.9392 2.21178L9.52922 7.82178H7.11922C6.71922 7.82178 6.32922 7.85178 5.94922 7.93178L6.94922 5.53178L6.98922 5.44178L7.04922 5.28178C7.07922 5.21178 7.09922 5.15178 7.12922 5.10178C8.28922 2.41178 9.58922 1.57178 11.9392 2.21178Z" fill="#00bcd4"/><path d="M18.7311 8.08953L18.7111 8.07953C18.1111 7.90953 17.5011 7.81953 16.8811 7.81953H10.6211L12.8711 2.58953L12.9011 2.51953C13.0411 2.56953 13.1911 2.63953 13.3411 2.68953L15.5511 3.61953C16.7811 4.12953 17.6411 4.65953 18.1711 5.29953C18.2611 5.41953 18.3411 5.52953 18.4211 5.65953C18.5111 5.79953 18.5811 5.93953 18.6211 6.08953C18.6611 6.17953 18.6911 6.25953 18.7111 6.34953C18.8611 6.85953 18.8711 7.43953 18.7311 8.08953Z" fill="#00bcd4"/><path d="M12.5195 17.6581H12.7695C13.0695 17.6581 13.3195 17.3881 13.3195 17.0581C13.3195 16.6381 13.1995 16.5781 12.9395 16.4781L12.5195 16.3281V17.6581Z" fill="#00bcd4"/><path d="M18.2883 9.52031C17.8383 9.39031 17.3683 9.32031 16.8783 9.32031H7.11828C6.43828 9.32031 5.79828 9.45031 5.19828 9.71031C3.45828 10.4603 2.23828 12.1903 2.23828 14.2003V16.1503C2.23828 16.3903 2.25828 16.6203 2.28828 16.8603C2.50828 20.0403 4.20828 21.7403 7.38828 21.9503C7.61828 21.9803 7.84828 22.0003 8.09828 22.0003H15.8983C19.5983 22.0003 21.5483 20.2403 21.7383 16.7403C21.7483 16.5503 21.7583 16.3503 21.7583 16.1503V14.2003C21.7583 11.9903 20.2883 10.1303 18.2883 9.52031ZM13.2783 15.5003C13.7383 15.6603 14.3583 16.0003 14.3583 17.0603C14.3583 17.9703 13.6483 18.7003 12.7683 18.7003H12.5183V18.9203C12.5183 19.2103 12.2883 19.4403 11.9983 19.4403C11.7083 19.4403 11.4783 19.2103 11.4783 18.9203V18.7003H11.3883C10.4283 18.7003 9.63828 17.8903 9.63828 16.8903C9.63828 16.6003 9.86828 16.3703 10.1583 16.3703C10.4483 16.3703 10.6783 16.6003 10.6783 16.8903C10.6783 17.3103 10.9983 17.6603 11.3883 17.6603H11.4783V15.9703L10.7183 15.7003C10.2583 15.5403 9.63828 15.2003 9.63828 14.1403C9.63828 13.2303 10.3483 12.5003 11.2283 12.5003H11.4783V12.2803C11.4783 11.9903 11.7083 11.7603 11.9983 11.7603C12.2883 11.7603 12.5183 11.9903 12.5183 12.2803V12.5003H12.6083C13.5683 12.5003 14.3583 13.3103 14.3583 14.3103C14.3583 14.6003 14.1283 14.8303 13.8383 14.8303C13.5483 14.8303 13.3183 14.6003 13.3183 14.3103C13.3183 13.8903 12.9983 13.5403 12.6083 13.5403H12.5183V15.2303L13.2783 15.5003Z" fill="#00bcd4"/><path d="M10.6797 14.1391C10.6797 14.5591 10.7997 14.6191 11.0597 14.7191L11.4797 14.8691V13.5391H11.2297C10.9197 13.5391 10.6797 13.8091 10.6797 14.1391Z" fill="#00bcd4"/></svg> {__("Monetization")}
							</a>
							<div class='collapse {if $view == "monetization"}show{/if}' id="monetization-settings">
								<ul>
									<li {if $view == "monetization" && $sub_view == ""}class="active" {/if}>
										<a href="{$system['system_url']}/settings/monetization">
											{__("Settings")}
										</a>
									</li>
									{if $system['monetization_money_withdraw_enabled']}
										<li {if $view == "monetization" && $sub_view == "payments"}class="active" {/if}>
											<a href="{$system['system_url']}/settings/monetization/payments">
												{__("Payments")}
											</a>
										</li>
									{/if}
									<li {if $view == "monetization" && $sub_view == "earnings"}class="active" {/if}>
										<a href="{$system['system_url']}/settings/monetization/earnings">
											{__("Earnings")}
										</a>
									</li>
								</ul>
							</div>
						</li>
					{/if}

					{if $system['coinpayments_enabled']}
						<li {if $view == "coinpayments"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/coinpayments">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M23.0004 15.2188C22.5904 15.2188 22.2504 15.5588 22.2504 15.9688C22.2504 18.9288 20.1904 21.4087 17.4204 22.0587L17.6904 21.6088C17.9004 21.2488 17.7904 20.7887 17.4304 20.5787C17.0804 20.3687 16.6104 20.4787 16.4004 20.8387L15.3504 22.5887C15.2104 22.8187 15.2104 23.1087 15.3404 23.3387C15.4704 23.5787 15.7204 23.7187 15.9904 23.7187C20.2604 23.7187 23.7404 20.2387 23.7404 15.9688C23.7504 15.5588 23.4104 15.2188 23.0004 15.2188Z" fill="#EF8E19"/><path d="M8 0.21875C3.73 0.21875 0.25 3.69875 0.25 7.96875C0.25 8.37875 0.59 8.71875 1 8.71875C1.41 8.71875 1.75 8.37875 1.75 7.96875C1.75 5.00875 3.81 2.52875 6.58 1.87875L6.31 2.32875C6.1 2.68875 6.21 3.14875 6.57 3.35875C6.92 3.56875 7.39 3.45875 7.6 3.09875L8.65 1.34875C8.78 1.11875 8.79 0.83875 8.65 0.59875C8.52 0.36875 8.27 0.21875 8 0.21875Z" fill="#EF8E19"/><path d="M21.5002 8.67C21.5002 11.75 19.2602 14.29 16.3302 14.76C16.3302 14.75 16.3302 14.75 16.3302 14.74C16.0402 11.01 13.0202 7.97 9.24023 7.67C9.71023 4.74 12.2502 2.5 15.3302 2.5C18.7402 2.5 21.5002 5.26 21.5002 8.67Z" fill="#EF8E19"/><path d="M9.80914 14.2003C9.80914 14.0503 9.63914 13.8203 9.42914 13.8203H7.36914V14.5703H9.42914C9.63914 14.5803 9.80914 14.4103 9.80914 14.2003Z" fill="#EF8E19"/><path d="M9.82914 16.0781H9.42914H7.36914V16.8281H9.83914C10.1591 16.8281 10.3791 16.6281 10.3791 16.4481C10.3791 16.2681 10.1491 16.0781 9.82914 16.0781Z" fill="#EF8E19"/><path d="M14.83 14.8484C14.6 11.8184 12.18 9.39844 9.15 9.16844C8.99 9.15844 8.84 9.14844 8.67 9.14844C5.26 9.14844 2.5 11.9084 2.5 15.3284C2.5 18.7384 5.26 21.4984 8.67 21.4984C12.08 21.4984 14.85 18.7384 14.85 15.3284C14.85 15.1584 14.84 15.0084 14.83 14.8484ZM9.83 18.3284H9.17V18.7084C9.17 19.1184 8.83 19.4584 8.42 19.4584C8.01 19.4584 7.67 19.1184 7.67 18.7084V18.3284H6.62C6.21 18.3284 5.87 17.9884 5.87 17.5784V15.3284V13.0784C5.87 12.6684 6.21 12.3284 6.62 12.3284H7.67V11.9484C7.67 11.5384 8.01 11.1984 8.42 11.1984C8.83 11.1984 9.17 11.5384 9.17 11.9484V12.3284H9.43C10.43 12.3284 11.31 13.2084 11.31 14.2084C11.31 14.4984 11.24 14.7684 11.12 15.0184C11.58 15.3584 11.87 15.8784 11.87 16.4584C11.87 17.4884 10.96 18.3284 9.83 18.3284Z" fill="#EF8E19"/></svg> {__("CoinPayments")}
							</a>
						</li>
					{/if}

					{if $system['bank_transfers_enabled']}
						<li {if $view == "bank"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/bank">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M22 19V22H2V19C2 18.45 2.45 18 3 18H21C21.55 18 22 18.45 22 19Z" fill="#4caf50" stroke="#4caf50" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M7 11H5V18H7V11Z" fill="#4caf50"/><path d="M11 11H9V18H11V11Z" fill="#4caf50"/><path d="M15 11H13V18H15V11Z" fill="#4caf50"/><path d="M19 11H17V18H19V11Z" fill="#4caf50"/><path d="M23 22.75H1C0.59 22.75 0.25 22.41 0.25 22C0.25 21.59 0.59 21.25 1 21.25H23C23.41 21.25 23.75 21.59 23.75 22C23.75 22.41 23.41 22.75 23 22.75Z" fill="#4caf50"/><path d="M21.37 5.74984L12.37 2.14984C12.17 2.06984 11.83 2.06984 11.63 2.14984L2.63 5.74984C2.28 5.88984 2 6.29984 2 6.67984V9.99984C2 10.5498 2.45 10.9998 3 10.9998H21C21.55 10.9998 22 10.5498 22 9.99984V6.67984C22 6.29984 21.72 5.88984 21.37 5.74984ZM12 8.49984C11.17 8.49984 10.5 7.82984 10.5 6.99984C10.5 6.16984 11.17 5.49984 12 5.49984C12.83 5.49984 13.5 6.16984 13.5 6.99984C13.5 7.82984 12.83 8.49984 12 8.49984Z" fill="#4caf50"/></svg> {__("Bank Transfers")}
							</a>
						</li>
					{/if}

					{if $system['verification_requests']}
						<li {if $view == "verification"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/verification">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21.5609 10.7386L20.2009 9.15859C19.9409 8.85859 19.7309 8.29859 19.7309 7.89859V6.19859C19.7309 5.13859 18.8609 4.26859 17.8009 4.26859H16.1009C15.7109 4.26859 15.1409 4.05859 14.8409 3.79859L13.2609 2.43859C12.5709 1.84859 11.4409 1.84859 10.7409 2.43859L9.17086 3.80859C8.87086 4.05859 8.30086 4.26859 7.91086 4.26859H6.18086C5.12086 4.26859 4.25086 5.13859 4.25086 6.19859V7.90859C4.25086 8.29859 4.04086 8.85859 3.79086 9.15859L2.44086 10.7486C1.86086 11.4386 1.86086 12.5586 2.44086 13.2486L3.79086 14.8386C4.04086 15.1386 4.25086 15.6986 4.25086 16.0886V17.7986C4.25086 18.8586 5.12086 19.7286 6.18086 19.7286H7.91086C8.30086 19.7286 8.87086 19.9386 9.17086 20.1986L10.7509 21.5586C11.4409 22.1486 12.5709 22.1486 13.2709 21.5586L14.8509 20.1986C15.1509 19.9386 15.7109 19.7286 16.1109 19.7286H17.8109C18.8709 19.7286 19.7409 18.8586 19.7409 17.7986V16.0986C19.7409 15.7086 19.9509 15.1386 20.2109 14.8386L21.5709 13.2586C22.1509 12.5686 22.1509 11.4286 21.5609 10.7386ZM16.1609 10.1086L11.3309 14.9386C11.1909 15.0786 11.0009 15.1586 10.8009 15.1586C10.6009 15.1586 10.4109 15.0786 10.2709 14.9386L7.85086 12.5186C7.56086 12.2286 7.56086 11.7486 7.85086 11.4586C8.14086 11.1686 8.62086 11.1686 8.91086 11.4586L10.8009 13.3486L15.1009 9.04859C15.3909 8.75859 15.8709 8.75859 16.1609 9.04859C16.4509 9.33859 16.4509 9.81859 16.1609 10.1086Z" fill="#2196f3"/></svg> {__("Verification")}
							</a>
						</li>
					{/if}

					{if $system['developers_apps_enabled']}
						<li {if $view == "apps"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/apps">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19.3297 5.68125L13.0597 2.30125C12.3997 1.94125 11.5997 1.94125 10.9397 2.30125L4.66969 5.68125C4.20969 5.93125 3.92969 6.41125 3.92969 6.96125C3.92969 7.50125 4.20969 7.99125 4.66969 8.24125L10.9397 11.6213C11.2697 11.8013 11.6397 11.8913 11.9997 11.8913C12.3597 11.8913 12.7297 11.8013 13.0597 11.6213L19.3297 8.24125C19.7897 7.99125 20.0697 7.51125 20.0697 6.96125C20.0697 6.41125 19.7897 5.93125 19.3297 5.68125Z" fill="#424242"/><path d="M9.91 12.79L4.07 9.87C3.62 9.65 3.1 9.67 2.68 9.93C2.25 10.2 2 10.65 2 11.15V16.66C2 17.61 2.53 18.47 3.38 18.9L9.21 21.82C9.41 21.92 9.63 21.97 9.85 21.97C10.11 21.97 10.37 21.9 10.6 21.76C11.03 21.5 11.28 21.04 11.28 20.54V15.03C11.29 14.07 10.76 13.21 9.91 12.79Z" fill="#424242"/><path d="M21.3207 9.93014C20.8907 9.67014 20.3707 9.64014 19.9307 9.87014L14.1007 12.7901C13.2507 13.2201 12.7207 14.0701 12.7207 15.0301V20.5401C12.7207 21.0401 12.9707 21.5001 13.4007 21.7601C13.6307 21.9001 13.8907 21.9701 14.1507 21.9701C14.3707 21.9701 14.5907 21.9201 14.7907 21.8201L20.6207 18.9001C21.4707 18.4701 22.0007 17.6201 22.0007 16.6601V11.1501C22.0007 10.6501 21.7507 10.2001 21.3207 9.93014Z" fill="#424242"/></svg> {__("Apps")}
							</a>
						</li>
					{/if}

					<li {if $view == "blocking"}class="active"{/if}>
						<a href="{$system['system_url']}/settings/blocking">
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 2C6.49 2 2 6.49 2 12C2 17.51 6.49 22 12 22C17.51 22 22 17.51 22 12C22 6.49 17.51 2 12 2ZM15.92 12.75H7.92C7.51 12.75 7.17 12.41 7.17 12C7.17 11.59 7.51 11.25 7.92 11.25H15.92C16.33 11.25 16.67 11.59 16.67 12C16.67 12.41 16.34 12.75 15.92 12.75Z" fill="#ff5722"/></svg> {__("Blocking")}
						</a>
					</li>
					
					{if $system['download_info_enabled']}
						<li {if $view == "information"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/information">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 4.25C16 5.49 14.99 6.5 13.75 6.5H10.25C9.63 6.5 9.07 6.25 8.66 5.84C8.25 5.43 8 4.87 8 4.25C8 3.01 9.01 2 10.25 2H13.75C14.37 2 14.93 2.25 15.34 2.66C15.75 3.07 16 3.63 16 4.25Z" fill="#28a745"/><path d="M18.83 5.02874C18.6 4.83874 18.34 4.68874 18.06 4.57874C17.77 4.46874 17.48 4.69874 17.42 4.99874C17.08 6.70874 15.57 7.99874 13.75 7.99874H10.25C9.25 7.99874 8.31 7.60874 7.6 6.89874C7.08 6.37874 6.72 5.71874 6.58 5.00874C6.52 4.70874 6.22 4.46874 5.93 4.58874C4.77 5.05874 4 6.11874 4 8.24874V17.9987C4 20.9987 5.79 21.9987 8 21.9987H16C18.21 21.9987 20 20.9987 20 17.9987V8.24874C20 6.61874 19.55 5.61874 18.83 5.02874ZM8 12.2487H12C12.41 12.2487 12.75 12.5887 12.75 12.9987C12.75 13.4087 12.41 13.7487 12 13.7487H8C7.59 13.7487 7.25 13.4087 7.25 12.9987C7.25 12.5887 7.59 12.2487 8 12.2487ZM16 17.7487H8C7.59 17.7487 7.25 17.4087 7.25 16.9987C7.25 16.5887 7.59 16.2487 8 16.2487H16C16.41 16.2487 16.75 16.5887 16.75 16.9987C16.75 17.4087 16.41 17.7487 16 17.7487Z" fill="#28a745"/></svg> {__("Your Information")}
							</a>
						</li>
					{/if}
					
					{if $system['delete_accounts_enabled']}
						<li {if $view == "delete"}class="active"{/if}>
							<a href="{$system['system_url']}/settings/delete">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81V16.18C2 19.83 4.17 22 7.81 22H16.18C19.82 22 21.99 19.83 21.99 16.19V7.81C22 4.17 19.83 2 16.19 2ZM15.76 15.76C15.7 16.61 15.63 17.67 13.71 17.67H10.29C8.38 17.67 8.3 16.61 8.24 15.76L7.93 11.8C7.91 11.54 8 11.29 8.17 11.1C8.34 10.91 8.59 10.81 8.84 10.81H15.16C15.41 10.81 15.66 10.92 15.83 11.1C16 11.29 16.09 11.54 16.07 11.79L15.76 15.76ZM16.8 9.82C16.78 9.82 16.76 9.82 16.74 9.82C15.7 9.72 14.75 9.65 13.84 9.61C12.62 9.55 11.4 9.53 10.17 9.58C9.57 9.61 8.96 9.65 8.36 9.71L7.27 9.82C7.25 9.82 7.22 9.82 7.2 9.82C6.85 9.82 6.55 9.56 6.52 9.2C6.48 8.83 6.76 8.49 7.13 8.46L8.22 8.35C8.65 8.31 9.07 8.28 9.5 8.26L9.58 7.79C9.66 7.29 9.81 6.33 11.31 6.33H12.7C14.21 6.33 14.36 7.32 14.43 7.8L14.51 8.28C15.26 8.32 16.03 8.38 16.87 8.46C17.25 8.5 17.52 8.83 17.49 9.21C17.45 9.56 17.15 9.82 16.8 9.82Z" fill="#f44336"/></svg> {__("Delete Account")}
							</a>
						</li>
					{/if}
				</ul>
            </div>
        </div>
        <!-- left panel -->

        <!-- right panel -->
        <div class="col-lg-9">
			<div class="mb10 pb10 border-bottom d-block d-lg-none">
				<div class="text-link d-flex align-items-center" onclick="$('body').toggleClass('show_sett_side');">
					<svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.99996 16.9998L4 11.9997L9 6.99976" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M4 12H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>&nbsp;&nbsp;{__("Back To Settings")}
				</div>
			</div>
	  
            <div class="ele_content p-4 mt-md-3 mt-lg-0 mb-5">

                {if $view == ""}
					{include file='settings.account.tpl'}
				{elseif $view == "profile"}
					{include file='settings.profile.tpl'}
				{elseif $view == "security"}
					{include file='settings.security.tpl'}
				{elseif $view == "privacy"}
					{include file='settings.privacy.tpl'}
				{elseif $view == "notifications"}
					{include file='settings.notifications.tpl'}
				{elseif $view == "accounts"}
					{include file='settings.accounts.tpl'}
				{elseif $view == "linked"}
					{include file='settings.linked.tpl'}
				{elseif $view == "membership"}
					{include file='settings.membership.tpl'}
				{elseif $view == "invitations"}
					{include file='settings.invitations.tpl'}
				{elseif $view == "affiliates"}
					{include file='settings.affiliates.tpl'}
				{elseif $view == "points"}
					{include file='settings.points.tpl'}
				{elseif $view == "market"}
					{include file='settings.market.tpl'}
				{elseif $view == "funding"}
					{include file='settings.funding.tpl'}
				{elseif $view == "monetization"}
					{include file='settings.monetization.tpl'}
				{elseif $view == "coinpayments"}
					{include file='settings.coinpayments.tpl'}
				{elseif $view == "bank"}
					{include file='settings.bank.tpl'}
				{elseif $view == "verification"}
					{include file='settings.verification.tpl'}
				{elseif $view == "apps"}
					{include file='settings.apps.tpl'}
				{elseif $view == "blocking"}
					{include file='settings.blocking.tpl'}
				{elseif $view == "addresses"}
					{include file='settings.addresses.tpl'}
				{elseif $view == "information"}
					{include file='settings.information.tpl'}
				{elseif $view == "delete"}
					{include file='settings.delete.tpl'}
				{/if}
                
            </div>
        </div>
        <!-- right panel -->
        </div>
    </div>
</div>
<!-- page content -->

{include file='_footer.tpl'}